ORCA/M Asm65816 2.1.0

0001 4B8C
0002 4B8C              ;	This EdAsm/Asm816 source code file was converted to AsmIIGS
0003 4B8C              ;	by EdAsmCvtIIGS version 1.2d8 on 5/16/91 at 9:23:15 PM
0004 4B8C
0005 4B8C                       TITLE 'Extra Bits Shift Tables'
0006 4B8C                                                      ; SEG	code
0007 4B8C 00 00 00 00  ASHIFT   DC B:0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
0008 4B9C 40 40 40 40           DC B:64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64
0009 4BAC 80 80 80 80           DC B:128,128,128,128,128,128,128,128
0010 4BB4 80 80 80 80           DC B:128,128,128,128,128,128,128,128
0011 4BBC C0 C0 C0 C0           DC B:192,192,192,192,192,192,192,192
0012 4BC4 C0 C0 C0 C0           DC B:192,192,192,192,192,192,192,192
0013 4BCC              *
0014 4BCC 00 00 00 00  BSHIFT   DC B:0,0,0,0,64,64,64,64
0015 4BD4 80 80 80 80           DC B:128,128,128,128,192,192,192,192
0016 4BDC 00 00 00 00           DC B:0,0,0,0,64,64,64,64
0017 4BE4 80 80 80 80           DC B:128,128,128,128,192,192,192,192
0018 4BEC 00 00 00 00           DC B:0,0,0,0,64,64,64,64
0019 4BF4 80 80 80 80           DC B:128,128,128,128,192,192,192,192
0020 4BFC 00 00 00 00           DC B:0,0,0,0,64,64,64,64
0021 4C04 80 80 80 80           DC B:128,128,128,128,192,192,192,192
0022 4C0C              *
0023 4C0C 00 40 80 C0  CSHIFT   DC B:0,64,128,192,0,64,128,192
0024 4C14 00 40 80 C0           DC B:0,64,128,192,0,64,128,192
0025 4C1C 00 40 80 C0           DC B:0,64,128,192,0,64,128,192
0026 4C24 00 40 80 C0           DC B:0,64,128,192,0,64,128,192
0027 4C2C 00 40 80 C0           DC B:0,64,128,192,0,64,128,192
0028 4C34 00 40 80 C0           DC B:0,64,128,192,0,64,128,192
0029 4C3C 00 40 80 C0           DC B:0,64,128,192,0,64,128,192
0030 4C44 00 40 80 C0           DC B:0,64,128,192,0,64,128,192
0031 4C4C              *
0032 4C4C FF FF FF              DC B:$03,$FF                   ;Just for now
0033 4C4F                                                      ; SEG	fake_it
0034 4C4F                       TITLE 'Read Address Field'
0035 4C4F              **************************************************
0036 4C4F              *                                                *
0037 4C4F              *  rdaddr                Read an address field   *
0038 4C4F              *                                 with timeout   *
0039 4C4F              *                                                *
0040 4C4F              *   Output:   sectinfo[0..4] of sector found     *
0041 4C4F              *             C <- clr:all okay, set:field error *
0042 4C4F              *   Destroys: A, X, Y, temp                      *
0043 4C4F              *                                                *
0044 4C4F              **************************************************
0045 4C4F                                                      ; SEG	code	; point to bank $FF
0046 4C4F              RDADDR   EQU   *
0047 4C4F                                                      ; SEG	fake_it	;
0048 4C4F 5C 6F 0F E1  @notMFM  JMP   >RdAddrHook
0049 4C53              *
0050 4C53              * Wait until any seeking/speed changing/head settling finishes
0051 4C53              *
0052 4C53 20 25 49     RdAddr~GCR JSR   WaitRdyTO              ;Wait ready with TimeOut
0053 4C56 B0 63                 BCS   NeverRdy
0054 4C58              *
0055 4C58              * Set IWM into read mode
0056 4C58              *
0057 4C58 20 C6 4C              JSR   rdmode                   ;Set read mode with hdsel 
0058 4C5B              *
0059 4C5B              * Set up the timeout
0060 4C5B              *
0061 4C5B A9 07                 LDA   #>amtout
0062 4C5D 85 5A                 STA   temp
0063 4C5F A0 9E                 LDY   #<amtout
0064 4C61              *
0065 4C61              * Find the 3 address marks
0066 4C61              *
0067 4C61 A2 02        RMB      LDX   #2                       ;Three of 'em
0068 4C63 88           RMC      DEY                            ;Maintain double byte t.o. ctr
0069 4C64 D0 04                 BNE   rma                      ;=> no timeout
0070 4C66 C6 5A                 DEC   temp
0071 4C68 30 4A                 BMI   rmerr                    ;Oops, timeout error
0072 4C6A              * 
0073 4C6A AD EC C0     RMA      LDA   l6clr                    ;Look for a byte
0074 4C6D 10 FB                 BPL   rma                      ;Branch if no byte ready
0075 4C6F DD 69 0F              CMP   adrmarks,x               ;Is it the right mark? 
0076 4C72 D0 ED                 BNE   rmb                      ;No, start all over 
0077 4C74 CA                    DEX                            ;Yes, found a mark 
0078 4C75 10 EC                 BPL   rmc                      ;If more marks, go back 
0079 4C77              *
0080 4C77              * Found an address field. Now grab the info 
0081 4C77              *
0082 4C77 A0 04                 LDY   #4                       ;Four pieces of info + csum
0083 4C79 64 4F                 STZ   csum
0084 4C7B AE EC C0     RMD      LDX   l6clr                    ;Get a byte
0085 4C7E 10 FB                 BPL   rmd                      ;If not ready, back again
0086 4C80 BF 00 3C FF           LDA   >dnibtab,x               ;Perform 8 to 6 bit xform 
0087 4C84 99 30 0F              STA   sectinfo,y               ;Save that chunk 
0088 4C87 45 4F                 EOR   csum                     ;Add into the checksum
0089 4C89 85 4F                 STA   csum
0090 4C8B 88                    DEY                            ;One less piece of info
0091 4C8C 10 ED                 BPL   rmd                      ;If more, go back
0092 4C8E              *
0093 4C8E              * The last byte was the checksum. If our calculated
0094 4C8E              *  checksum is not zero now, we've had a problem
0095 4C8E              *
0096 4C8E A8                    TAY   
0097 4C8F D0 23                 BNE   rmerr
0098 4C91              *
0099 4C91              * Now identify the bitslip marks
0100 4C91              *
0101 4C91 AD EC C0     RME      LDA   l6clr
0102 4C94 10 FB                 BPL   rme
0103 4C96 CD 63 0F              CMP   bslip1
0104 4C99 D0 19                 BNE   rmerr
0105 4C9B              *
0106 4C9B AD EC C0     RMF      LDA   l6clr
0107 4C9E 10 FB                 BPL   rmf
0108 4CA0 CD 62 0F              CMP   bslip2
0109 4CA3 D0 0F                 BNE   rmerr
0110 4CA5              *
0111 4CA5 AE 28 0F              LDX   drive
0112 4CA8 AD 31 0F              LDA   fmtfnd                   ;extract the DS bit from Fmt 
0113 4CAB 0A                    ASL   a
0114 4CAC 0A                    ASL   a
0115 4CAD 29 80                 AND   #$80
0116 4CAF 8D 2F 0F              STA   DblSided                 ;Set Dblsided per this volume
0117 4CB2              *
0118 4CB2 18                    CLC                            ;Got a good sector
0119 4CB3 60                    RTS   
0120 4CB4              *
0121 4CB4              * Error exit... we had either a timeout, checksum
0122 4CB4              *  or bitslip error
0123 4CB4              *
0124 4CB4              RMERR    EQU   *
0125 4CB4 A9 20                 LDA   #adrerror
0126 4CB6 0C 44 0F              TSB   error2
0127 4CB9 38                    SEC                            ;Set flag 
0128 4CBA 60                    RTS   
0129 4CBB              *
0130 4CBB A9 2F        NEVERRDY LDA   #offline
0131 4CBD 8D 4B 0F              STA   statbyte                 ;return an error code
0132 4CC0 A9 80                 LDA   #$80
0133 4CC2 85 5A                 STA   temp                     ;return BMI+ BVC 
0134 4CC4 80 EE                 BRA   rmerr
0135 4CC6              *
0136 4CC6              *
0137 4CC6              RDMODE   EQU   *
0138 4CC6 A9 01                 LDA   #read0adr
0139 4CC8 2C 2B 0F              BIT   side
0140 4CCB 10 02                 BPL   @10
0141 4CCD A9 03                 LDA   #read1adr
0142 4CCF 20 7B 49     @10      JSR   ReadBit
0143 4CD2 AD EE C0              LDA   l7clr
0144 4CD5 AD EC C0              LDA   l6clr
0145 4CD8 60                    RTS   
0146 4CD9                       TITLE 'Read Data Field'
0147 4CD9              **************************************************
0148 4CD9              *                                                *
0149 4CD9              *  readdata       Read a data field into buffer  *
0150 4CD9              *                                                *
0151 4CD9              *   Assumes:                                     *
0152 4CD9              *   INPUT :   cyl, sector, side                  *
0153 4CD9              *                                                *
0154 4CD9              **************************************************
0155 4CD9                                                      ; SEG	code	;
0156 4CD9              READDATA EQU   *
0157 4CD9                                                      ; SEG	fake_it	;
0158 4CD9              @notmfm   
0159 4CD9 5C 77 0F E1           JMP   >ReadDataHook
0160 4CDD              *
0161 4CDD 64 52        ReadData~GCR STZ   csuma
0162 4CDF 64 51                 STZ   csumb
0163 4CE1 64 50                 STZ   csumc
0164 4CE3              *
0165 4CE3 2C 42 0F              BIT   DRswtch
0166 4CE6 10 03                 BPL   @01
0167 4CE8 4C 18 4E              JMP   DirectRead
0168 4CEB              *
0169 4CEB              * Find the data marks
0170 4CEB              *
0171 4CEB A0 19        @01      LDY   #readto                  ;Rather short timeout
0172 4CED A2 02        RMXB     LDX   #2                       ;Three of 'em
0173 4CEF 88           RMXC     DEY                            ;Maintain t.o. ctr
0174 4CF0 F0 1B                 BEQ   rderr                    ;=> Too many bytes passed 
0175 4CF2              * 
0176 4CF2 AD EC C0     RMXA     LDA   l6clr                    ;Look for a byte
0177 4CF5 10 FB                 BPL   rmxa                     ;Branch if no byte ready
0178 4CF7 DD 58 0F              CMP   datamarks,x              ;Is it the right mark? 
0179 4CFA D0 F1                 BNE   rmxb                     ;No, start all over 
0180 4CFC CA                    DEX                            ;Yes, found a mark 
0181 4CFD 10 F0                 BPL   rmxc                     ;If more marks, go back 
0182 4CFF              *
0183 4CFF              * Found the data marks. Verify the sector mark.
0184 4CFF              *
0185 4CFF AE EC C0     RDA      LDX   l6clr
0186 4D02 10 FB                 BPL   rda
0187 4D04              *
0188 4D04 BF 00 3C FF           LDA   >dnibtab,x               ;Denibblize the sector mark
0189 4D08 CD 33 0F              CMP   sectfnd                  ;Same as address field?
0190 4D0B F0 03                 BEQ   rdaaa                    ;Yes, all okay...
0191 4D0D 4C BF 4D     RDERR    JMP   readerr
0192 4D10              *
0193 4D10              * Now read the field
0194 4D10              *
0195 4D10 A0 AF        RDAAA    LDY   #175                     ;175 groups of 4 nibs -1=699
0196 4D12 4C 2D 4D              JMP   rdb                      ;Skip into the loop
0197 4D15              *
0198 4D15 AE EC C0     RDE      LDX   l6clr                    ;(6-9,11)
0199 4D18 10 FB                 BPL   rde                      ;(3)
0200 4D1A BF 00 3C FF           LDA   >dnibtab,x               ;(4)
0201 4D1E A6 58                 LDX   exindex                  ;(3)
0202 4D20 1F 0C 4C FF           ORA   >cshift,x                ;(5) Add extra bits
0203 4D24 45 51                 EOR   csumb                    ;(3) Got CCCCCCCC
0204 4D26 99 01 0E              STA   buf3+1,y                 ;(6-9) store to bank $E1
0205 4D29 65 50                 ADC   csumc                    ;(3)
0206 4D2B 85 50                 STA   csumc                    ;(3)
0207 4D2D              *
0208 4D2D AE EC C0     RDB      LDX   l6clr                    ;(6-9,11) Get the top nybl
0209 4D30 10 FB                 BPL   rdb                      ;(3) Back if no byte 
0210 4D32 BF 00 3C FF           LDA   >dnibtab,x               ;(4) Denibblize extras
0211 4D36 85 58                 STA   exindex                  ;(3) Move them into Y
0212 4D38              *
0213 4D38 06 50                 ASL   csumc                    ;(5) Shift csumc
0214 4D3A 90 02                 BCC   rdc                      ;(3) Wrap carry around to lsB
0215 4D3C E6 50                 INC   csumc                    ;(5)  
0216 4D3E              *
0217 4D3E AE EC C0     RDC      LDX   l6clr                    ;(6-9,11) Get nybl A
0218 4D41 10 FB                 BPL   rdc                      ;(3) 
0219 4D43 BF 00 3C FF           LDA   >dnibtab,x               ;(4) Denib: 00AAAAAA
0220 4D47 A6 58                 LDX   exindex                  ;(3) Get back the extras index
0221 4D49 1F 8C 4B FF           ORA   >ashift,x                ;(5) AAAAAAAA XOR csumc
0222 4D4D 45 50                 EOR   csumc                    ;(3) AAAAAAAA
0223 4D4F 99 00 0C              STA   buf1,y                   ;(6-9) Keep the data byte 
0224 4D52 65 52                 ADC   csuma                    ;(3) A <- csuma + bytea 
0225 4D54              *
0226 4D54 AE EC C0     RDD      LDX   l6clr                    ;(6-9,11) Next Byte
0227 4D57 10 FB                 BPL   rdd                      ;(3)
0228 4D59 85 52                 STA   csuma                    ;(2) Get rid of that csuma
0229 4D5B BF 00 3C FF           LDA   >dnibtab,x               ;(5) Denib: 00BBBBBB
0230 4D5F A6 58                 LDX   exindex                  ;(3)
0231 4D61 1F CC 4B FF           ORA   >bshift,x                ;(5) BBBBBBBB XOR csuma
0232 4D65 45 52                 EOR   csuma                    ;(3) BBBBBBBB 
0233 4D67 99 00 0D              STA   buf2,y                   ;(6-9) Get rid of byteb
0234 4D6A 65 51                 ADC   csumb                    ;(3) Add it in to the carry
0235 4D6C 85 51                 STA   csumb                    ;(3) Keep it
0236 4D6E              *
0237 4D6E 88                    DEY                            ;(2) all groups?
0238 4D6F D0 A4                 BNE   rde                      ;(3)
0239 4D71              *
0240 4D71              * Now grab, decode, and verify the checksum bytes
0241 4D71              *
0242 4D71 AE EC C0     RDF      LDX   l6clr                    ;(4) Get the extras
0243 4D74 10 FB                 BPL   rdf                      ;(2) Wait until byte ready
0244 4D76 BF 00 3C FF           LDA   >dnibtab,x               ;(4) Denibbilize it
0245 4D7A AA                    TAX                            ; (2) save it
0246 4D7B BF 0C 4C FF           LDA   >cshift,x                ;(4) Grab C extras in A[7..6]
0247 4D7F 85 58                 STA   exindex                  ;(3) Keep for later
0248 4D81 BF CC 4B FF           LDA   >bshift,x                ;(4) Get shifted B extras
0249 4D85 85 59                 STA   exindex2                 ;(3)
0250 4D87 BF 8C 4B FF           LDA   >ashift,x                ;(4) Get A extras shifted
0251 4D8B              *
0252 4D8B A0 02                 LDY   #2
0253 4D8D              *
0254 4D8D AE EC C0     RDG      LDX   l6clr                    ;(4)
0255 4D90 10 FB                 BPL   rdg                      ;(2) Wait until byte ready
0256 4D92 29 C0                 AND   #$C0                     ;(2) Isolate hi bits in A
0257 4D94 1F 00 3C FF           ORA   >dnibtab,x               ;(4) 'or' in denibbed low 6
0258 4D98 BB                    TYX                            ; need fast addressing
0259 4D99 D5 50                 CMP   csumc,x                  ;(4) Is it what we calc'd?
0260 4D9B D0 16                 BNE   dcsumerr                 ;(2) If not, flag a checksum error
0261 4D9D B5 57                 LDA   exindex-1,x              ;(4) Get next hi set of extras
0262 4D9F 88                    DEY                            ;(2) Almost done
0263 4DA0 10 EB                 BPL   rdg                      ;(3) Back maybe...
0264 4DA2              *
0265 4DA2              * Checksum okay... How are the bitslip bytes?
0266 4DA2              *
0267 4DA2 A0 02                 LDY   #2                       ;(2) Got two bitslip marks 
0268 4DA4 AD EC C0     RDH      LDA   l6clr                    ;(4) Wait for a byte
0269 4DA7 10 FB                 BPL   rdh                      ;(2) 
0270 4DA9 D9 61 0F              CMP   bsmarks,y                ;(4) Right one?
0271 4DAC D0 09                 BNE   dbserr                   ;(2) If not, you know where to go
0272 4DAE 88                    DEY                            ;(2)
0273 4DAF D0 F3                 BNE   rdh                      ;(3) Get the other mark
0274 4DB1              *
0275 4DB1              * Return good...we did it!
0276 4DB1              *
0277 4DB1 18                    CLC   
0278 4DB2 60                    RTS   
0279 4DB3              *
0280 4DB3              * 'Blew it' code
0281 4DB3              *
0282 4DB3 A9 10        DCSUMERR LDA   #dcserror
0283 4DB5 D0 02                 BNE   rdi
0284 4DB7              *
0285 4DB7 A9 08        DBSERR   LDA   #dbserror
0286 4DB9              *
0287 4DB9 0D 44 0F     RDI      ORA   error2
0288 4DBC 8D 44 0F              STA   error2
0289 4DBF              *
0290 4DBF 38           READERR  SEC   
0291 4DC0 60                    RTS   
0292 4DC1              *
0293 4DC1              *
0294 4DC1              DR~ADRS  EQU   *-Rel~Org+Bnk~Org
0295 4DC1              DR~ADRSL EQU   DR~ADRS**$00FF
0296 4DC1              DR~ADRSH EQU   (DR~ADRS**$FF00)>>8
0297 4DC1                       IF DR~ADRSL-24 > 0 THEN 
0298 4DC1 FF FF FF FF           DC B:((DR~ADRSH+1)*256+24)-DR~ADRS,$FF
0299 4E18                       ENDIF 
0300 4E18                       TITLE 'Direct Read Data Field'
0301 4E18              **********************************************************
0302 4E18              *                                                        *
0303 4E18              * DirectRead: Read data field directly to users buffer   *
0304 4E18              *                                                        *
0305 4E18              *   Assumes: the user buffer is in fast ram              *
0306 4E18              *            i.e. not in $E0-E1 or $00-01 with shadowing *
0307 4E18              *         and the buffer does NOT span a bank boundary!! *
0308 4E18              *                                                        *
0309 4E18              *   Output:   512 bytes stored in user buffer            *
0310 4E18              *                                                        *
0311 4E18              **********************************************************
0312 4E18                                                      ; SEG	code
0313 4E18              DIRECTREAD EQU   *
0314 4E18                                                      ; SEG	fake_it
0315 4E18              *
0316 4E18              * Find the data marks
0317 4E18              *
0318 4E18 A0 19                 LDY   #readto                  ;Rather short timeout
0319 4E1A A2 02        @02      LDX   #2                       ;Three of 'em
0320 4E1C 88           @04      DEY                            ;Maintain t.o. ctr
0321 4E1D F0 72                 BEQ   @rderr                   ;=> Too many bytes passed 
0322 4E1F              * 
0323 4E1F AD EC C0              LDA   l6clr                    ;Look for a byte
0324 4E22 10 FB                 BPL   *-3                      ;Branch if no byte ready
0325 4E24 DD 58 0F              CMP   datamarks,x              ;Is it the right mark? 
0326 4E27 D0 F1                 BNE   @02                      ;No, start all over 
0327 4E29 CA                    DEX                            ;Yes, found a mark 
0328 4E2A 10 F0                 BPL   @04                      ;If more marks, go back 
0329 4E2C              *
0330 4E2C              * Found the data marks. Verify the sector number matches adrs field
0331 4E2C              *
0332 4E2C AE EC C0              LDX   l6clr
0333 4E2F 10 FB                 BPL   *-3
0334 4E31              *
0335 4E31 BF 00 3C FF           LDA   >dnibtab,x               ;Denibblize the sector mark
0336 4E35 4D 33 0F              EOR   sectfnd                  ;leave zero in A for cksum algorthm
0337 4E38 D0 57                 BNE   @rderr
0338 4E3A              *
0339 4E3A              * Now read the 16 nybl (12 bytes) tag field
0340 4E3A              *
0341 4E3A A0 0C                 LDY   #12
0342 4E3C 18                    CLC   
0343 4E3D AE EC C0     @TAGLOOP LDX   l6clr                    ;(6-9,11)
0344 4E40              *
0345 4E40 10 FB                 BPL   *-3                      ;(3)
0346 4E42 65 50                 ADC   csumc                    ;(2)
0347 4E44 C9 80                 CMP   #$80                     ;(2)
0348 4E46 2A                    ROL   a                        ;(2)
0349 4E47 85 50                 STA   csumc                    ;(3)
0350 4E49 BF 00 3C FF           LDA   >dnibtab,x               ;(5)
0351 4E4D 85 58                 STA   exindex                  ;(3)
0352 4E4F AE EC C0              LDX   l6clr                    ;(6-9,11)
0353 4E52              *
0354 4E52 10 FB                 BPL   *-3                      ;(3)
0355 4E54 BF 00 3C FF           LDA   >dnibtab,x               ;(4)
0356 4E58 A6 58                 LDX   exindex                  ;(3)
0357 4E5A 1F 8C 4B FF           ORA   >ashift,x                ;(5)
0358 4E5E 45 50                 EOR   csumc                    ;(3)
0359 4E60 65 52                 ADC   csuma                    ;(3) just perform cksum algorithm
0360 4E62 85 52                 STA   csuma                    ;(3)
0361 4E64 88                    DEY                            ;(2)
0362 4E65 AE EC C0              LDX   l6clr                    ;(6-9,11)
0363 4E68              *
0364 4E68 10 FB                 BPL   *-3                      ;(3)
0365 4E6A BF 00 3C FF           LDA   >dnibtab,x               ;(4)
0366 4E6E A6 58                 LDX   exindex                  ;(3)
0367 4E70 1F CC 4B FF           ORA   >bshift,x                ;(5)
0368 4E74 45 52                 EOR   csuma                    ;(3)
0369 4E76 65 51                 ADC   csumb                    ;(3)
0370 4E78 85 51                 STA   csumb                    ;(3)
0371 4E7A 88                    DEY                            ;(2)
0372 4E7B AE EC C0              LDX   l6clr                    ;(6-9,11)
0373 4E7E              *
0374 4E7E 10 FB                 BPL   *-3                      ;(3)
0375 4E80 BF 00 3C FF           LDA   >dnibtab,x               ;(4)
0376 4E84 A6 58                 LDX   exindex                  ;(3)
0377 4E86 1F 0C 4C FF           ORA   >cshift,x                ;(5)
0378 4E8A 45 51                 EOR   csumb                    ;(3)
0379 4E8C 88                    DEY                            ;(2)
0380 4E8D D0 AE                 BNE   @tagloop                 ;(3)
0381 4E8F 80 2F                 BRA   @go                      ;(3) enter the 1st page loop
0382 4E91 4C BF 4D     @RDERR   JMP   readerr
0383 4E94              *
0384 4E94              * Now read the 1st 256 data bytes of data field
0385 4E94              *
0386 4E94 AE EC C0     @PG1LOOP LDX   l6clr                    ;(6-9,11) (best-worst,loop)
0387 4E97 10 FB                 BPL   *-3                      ;(3)  get nybl B
0388 4E99 BF 00 3C FF           LDA   >dnibtab,x               ;(4) Denib: 00BBBBBB
0389 4E9D A6 58                 LDX   exindex                  ;(3) top bits index
0390 4E9F 1F CC 4B FF           ORA   >bshift,x                ;(5) BBBBBBBB XOR csuma
0391 4EA3 45 52                 EOR   csuma                    ;(3) BBBBBBBB
0392 4EA5 97 42                 STA   [cmdbuffl],y             ;(6) put the data byte b
0393 4EA7 C8                    INY                            ;(2)
0394 4EA8 65 51                 ADC   csumb                    ;(3) A <- csumb + byteb 
0395 4EAA 85 51                 STA   csumb                    ;(3) 
0396 4EAC              *
0397 4EAC AE EC C0              LDX   l6clr                    ;(6-9,11) 4 1us cycles/loop 
0398 4EAF 10 FB                 BPL   *-3                      ;(3)    get nybl C
0399 4EB1 BF 00 3C FF           LDA   >dnibtab,x               ;(4)
0400 4EB5 A6 58                 LDX   exindex                  ;(3)
0401 4EB7 1F 0C 4C FF           ORA   >cshift,x                ;(5) Add top bits 
0402 4EBB 45 51                 EOR   csumb                    ;(3) Got CCCCCCCC
0403 4EBD 97 42                 STA   [cmdbuffl],y             ;(6)
0404 4EBF C8                    INY                            ;(2)
0405 4EC0              *
0406 4EC0 AE EC C0     @GO      LDX   l6clr                    ;(6-9,11) Get the top bits nybl
0407 4EC3 10 FB                 BPL   *-3                      ;(3) Back if no byte 
0408 4EC5 65 50                 ADC   csumc                    ;(2)
0409 4EC7 C9 80                 CMP   #$80                     ;(2)
0410 4EC9 2A                    ROL   a                        ;(2)
0411 4ECA 85 50                 STA   csumc                    ;(3)
0412 4ECC BF 00 3C FF           LDA   >dnibtab,x               ;(5) Denibblize top bit nybl
0413 4ED0 85 58                 STA   exindex                  ;(3) 
0414 4ED2              *
0415 4ED2 AE EC C0              LDX   l6clr                    ;(6-9,11) Get nybl A
0416 4ED5 10 FB                 BPL   *-3                      ;(3) 
0417 4ED7 BF 00 3C FF           LDA   >dnibtab,x               ;(4) Denib: 00AAAAAA
0418 4EDB A6 58                 LDX   exindex                  ;(3) top bit index
0419 4EDD 1F 8C 4B FF           ORA   >ashift,x                ;(5) AAAAAAAA XOR csumc
0420 4EE1 45 50                 EOR   csumc                    ;(3) AAAAAAAA
0421 4EE3 97 42                 STA   [cmdbuffl],y             ;(6) put the data byte A   
0422 4EE5 65 52                 ADC   csuma                    ;(3) Add it in to the carry
0423 4EE7 85 52                 STA   csuma                    ;(3) Keep it
0424 4EE9 C8                    INY                            ;(2) end of 1st 256 bytes yet?
0425 4EEA D0 A8                 BNE   @pg1loop                 ;(3)
0426 4EEC              *
0427 4EEC              * cross over nybl to 2nd loop and 2nd code page!
0428 4EEC              * WARNING! The code page boundary must occur within the
0429 4EEC              *          following instructions before the loop label
0430 4EEC              *
0431 4EEC              ;DRCHK1		EQU	?*
0432 4EEC AE EC C0              LDX   l6clr                    ;(6-9,11) get the C nybl
0433 4EEF 10 FB                 BPL   *-3                      ;(3)
0434 4EF1 BF 00 3C FF           LDA   >dnibtab,x               ;(4)
0435 4EF5 A6 58                 LDX   exindex                  ;(3)
0436 4EF7 1F CC 4B FF           ORA   >bshift,x                ;(5)
0437 4EFB 45 52                 EOR   csuma                    ;(3)
0438 4EFD E6 43                 INC   cmdbuffl+1               ;(5) assumes no bank overflow!!!!
0439 4EFF 97 42                 STA   [cmdbuffl],y             ;(6)
0440 4F01 65 51                 ADC   csumb                    ;(3)
0441 4F03 85 51                 STA   csumb                    ;(3)
0442 4F05 C8                    INY                            ;(2)
0443 4F06              ;DRCHK2		EQU	?*
0444 4F06              ;		IF DRCHK2-DRCHK1-1 <> 0 THEN
0445 4F06              ;		WRITELN	'Direct Read page Alignment ERROR'
0446 4F06              ;		ENDIF
0447 4F06              *
0448 4F06              * Now read the 2nd 256 data bytes of data field
0449 4F06              *
0450 4F06 AE EC C0     @PG2LOOP LDX   l6clr                    ;(6-9,11)  (best-worst,loop)
0451 4F09 10 FB                 BPL   *-3                      ;(3)    (4 slow cycles/loop)
0452 4F0B BF 00 3C FF           LDA   >dnibtab,x               ;(4)
0453 4F0F A6 58                 LDX   exindex                  ;(3)
0454 4F11 1F 0C 4C FF           ORA   >cshift,x                ;(5) Add top bits 
0455 4F15 45 51                 EOR   csumb                    ;(3) Got CCCCCCCC
0456 4F17 97 42                 STA   [cmdbuffl],y             ;(6)
0457 4F19 C8                    INY                            ;(2)
0458 4F1A              *
0459 4F1A AE EC C0              LDX   l6clr                    ;(6-9,11) Get the top bits nybl
0460 4F1D 10 FB                 BPL   *-3                      ;(3) Back if no byte 
0461 4F1F 65 50                 ADC   csumc                    ;(2)
0462 4F21 C9 80                 CMP   #$80                     ;(2)
0463 4F23 2A                    ROL   a                        ;(2)
0464 4F24 85 50                 STA   csumc                    ;(3)
0465 4F26 BF 00 3C FF           LDA   >dnibtab,x               ;(5) Denibblize top bit nybl
0466 4F2A 85 58                 STA   exindex                  ;(3) 
0467 4F2C              *
0468 4F2C AE EC C0              LDX   l6clr                    ;(6-9,11) Get nybl A
0469 4F2F 10 FB                 BPL   *-3                      ;(3) 
0470 4F31 BF 00 3C FF           LDA   >dnibtab,x               ;(4) Denib: 00AAAAAA
0471 4F35 A6 58                 LDX   exindex                  ;(3) top bit index
0472 4F37 1F 8C 4B FF           ORA   >ashift,x                ;(5) AAAAAAAA XOR csumc
0473 4F3B 45 50                 EOR   csumc                    ;(3) AAAAAAAA
0474 4F3D 97 42                 STA   [cmdbuffl],y             ;(6) put the data byte 
0475 4F3F C8                    INY                            ;(2)
0476 4F40 65 52                 ADC   csuma                    ;(3) A <- csuma + bytea 
0477 4F42 85 52                 STA   csuma                    ;(3) 
0478 4F44              *
0479 4F44 AE EC C0              LDX   l6clr                    ;(6-9,11) get nybl B
0480 4F47 10 FB                 BPL   *-3                      ;(3)
0481 4F49 BF 00 3C FF           LDA   >dnibtab,x               ;(4) Denib: 00BBBBBB
0482 4F4D A6 58                 LDX   exindex                  ;(3)
0483 4F4F 1F CC 4B FF           ORA   >bshift,x                ;(5) BBBBBBBB XOR csuma
0484 4F53 45 52                 EOR   csuma                    ;(3) BBBBBBBB 
0485 4F55 97 42                 STA   [cmdbuffl],y             ;(6) Get rid of byteb
0486 4F57 65 51                 ADC   csumb                    ;(3) Add it in to the carry
0487 4F59 85 51                 STA   csumb                    ;(3) Keep it
0488 4F5B C8                    INY                            ;(2) done with 2nd page yet? 
0489 4F5C D0 A8                 BNE   @pg2loop                 ;(3)
0490 4F5E              *
0491 4F5E              * Now grab, decode, and verify the checksum bytes
0492 4F5E              *
0493 4F5E AE EC C0              LDX   l6clr                    ;(4) Get the extras
0494 4F61 10 FB                 BPL   *-3                      ;(2) Wait until byte ready
0495 4F63 BF 00 3C FF           LDA   >dnibtab,x               ;(5) Denibbilize it
0496 4F67 AA                    TAX                            ;(2) save it
0497 4F68 BF 0C 4C FF           LDA   >cshift,x                ;(5) Grab C extras in A[7..6]
0498 4F6C 85 58                 STA   exindex                  ;(3) Keep for later
0499 4F6E BF CC 4B FF           LDA   >bshift,x                ;(5) Get shifted B extras
0500 4F72 85 59                 STA   exindex2                 ;(3)
0501 4F74 BF 8C 4B FF           LDA   >ashift,x                ;(5) Get A extras shifted
0502 4F78              *
0503 4F78 A0 02                 LDY   #2
0504 4F7A              *
0505 4F7A AE EC C0     @80      LDX   l6clr                    ;(4)
0506 4F7D 10 FB                 BPL   *-3                      ;(3) Wait until byte ready
0507 4F7F 29 C0                 AND   #$C0                     ;(1) Isolate hi bits in A
0508 4F81 1F 00 3C FF           ORA   >dnibtab,x               ;(5) 'or' in denibbed low 6
0509 4F85 BB                    TYX                            ;(2) need zpg indexed addressing
0510 4F86 D5 50                 CMP   csumc,x                  ;(4) Is it what we calc'd?
0511 4F88 D0 18                 BNE   @110                     ;(2) If not, flag a checksum error
0512 4F8A B5 57                 LDA   exindex-1,x              ;(4) Get next hi set of extras
0513 4F8C 88                    DEY                            ;(2) Almost done
0514 4F8D 10 EB                 BPL   @80                      ;(3) Back maybe...
0515 4F8F              *
0516 4F8F              * Checksum okay... How are the bitslip mark?
0517 4F8F              *
0518 4F8F A0 02                 LDY   #2                       ;(2) Got two bitslip marks 
0519 4F91 AD EC C0     @90      LDA   l6clr                    ;(4) Wait for a byte
0520 4F94 10 FB                 BPL   *-3                      ;(2) 
0521 4F96 D9 61 0F              CMP   bsmarks,y                ;(4) Right one?
0522 4F99 D0 0B                 BNE   @120                     ;(2) If not, you know where to go
0523 4F9B 88                    DEY                            ;(2)
0524 4F9C D0 F3                 BNE   @90                      ;(3) Get the other mark
0525 4F9E              *
0526 4F9E              * Return good...we did it!
0527 4F9E              *
0528 4F9E C6 43                 DEC   cmdbuffl+1               ;restore buffr adrs
0529 4FA0 18                    CLC   
0530 4FA1 60                    RTS   
0531 4FA2              *
0532 4FA2              * 'Blew it' code
0533 4FA2              *
0534 4FA2 A9 10        @110     LDA   #dcserror
0535 4FA4 D0 02                 BNE   @130
0536 4FA6              *
0537 4FA6 A9 08        @120     LDA   #dbserror
0538 4FA8              *
0539 4FA8 C6 43        @130     DEC   cmdbuffl+1               ;restore buffer adrs
0540 4FAA 0D 44 0F              ORA   error2
0541 4FAD 8D 44 0F              STA   error2
0542 4FB0 38                    SEC   
0543 4FB1 60                    RTS   
